#ifndef	_ASM_MN10300_DMAALLOC_H
#define	_ASM_MN10300_DMAALLOC_H

#ifndef __ASSEMBLY__
#include <asm/ptrace.h>
#include <linux/types.h>
#include <linux/ioctl.h>
#include <linux/sockios.h>
#include <linux/autoconf.h>
#endif

#define DMAALLOC_PURGE_DMA_V		0   /* don't use */
#define DMAALLOC_PURGE_DMA_IV	    1
#define DMAALLOC_PURGE_MEM		    2   /* don't use */

struct dmaalloc_dmaalloc
{
  void **start;
  size_t len;
};

struct dmaalloc_dmafree
{
  void *start;
};

struct dmaalloc_purgedcache
{
  void *start_add;
  size_t size;
};

struct dmaalloc_ioctl
{
  union
  {
    struct dmaalloc_dmaalloc dmaalloc;
    struct dmaalloc_dmafree dmafree;
    struct dmaalloc_purgedcache purgedcache;
  } ioctl;
};

#define DMAALLOC_IOC_MAGIC		0xD0
#define DMAALLOC_IOCDMAALLOC		_IO(DMAALLOC_IOC_MAGIC, 1)
#define DMAALLOC_IOCDMAFREE 		_IO(DMAALLOC_IOC_MAGIC, 2)
#define DMAALLOC_IOCPURGEDCACHE     _IO(DMAALLOC_IOC_MAGIC, 3)
#ifdef SVC_MODULE_TEST
#define DMAALLOC_IOCTESTDMAALLOC		_IO(DMAALLOC_IOC_MAGIC, 4)
#endif /* SVC_MODULE_TEST */
#endif /* _ASM_MN10300_DMAALLOC_H */
